/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.ui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.ui.InstallerPanel;

final class Images {
    static List<Image> getWindowIcons() {
        ArrayList<Image> result = new ArrayList<Image>();
        result.add(Images.getImage("/icons/neoforged_background_16x16.png"));
        result.add(Images.getImage("/icons/neoforged_background_32x32.png"));
        result.add(Images.getImage("/icons/neoforged_background_128x128.png"));
        return result;
    }

    static BufferedImage getImage(String path) {
        return Images.getImage(path, null);
    }

    static BufferedImage getImage(String path, String default_) {
        try {
            InputStream in = SimpleInstaller.class.getResourceAsStream(path);
            if (in == null && default_ != null) {
                in = new ByteArrayInputStream(InstallerPanel.hexToByteArray(default_));
            }
            return ImageIO.read(in);
        }
        catch (IOException e) {
            if (default_ == null) {
                throw new RuntimeException(e);
            }
            return new BufferedImage(32, 32, 2);
        }
    }
}

